/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.

	$Id: pgpLDAPPriv.h,v 1.10 2000/04/21 02:50:57 dallen Exp $
____________________________________________________________________________*/
#ifndef Included_pgpLDAPPriv_h	/* [ */
#define Included_pgpLDAPPriv_h

#include "pgpLDAP.h"

#define	CKERR			if( IsPGPError( err ) ) { goto error; }
#define CKNULL(val)		if( IsNull( val ) ) \
						{ \
							err = kPGPError_OutOfMemory;\
							goto error;\
						}

typedef struct PGPldapContext
{
	char *				hostname;
	PGPInt16			port;

	PGPSocketRef		sock;

	PGPldapMessageID	nextMessageID;

	PGPldapMessageRef	response;

	/* Options */
	PGPUInt32			sizelimit;	/* Number of entries */
	PGPUInt32			timelimit;	/* Number of seconds */
	PGPldapDeref		deref;
	
	/* Global errors */
	PGPldapResult		result;
	char *				matched;
	char *				message;

	/* Thread-specific errors */
	PGPldapThreadFns	threadFns;

	PGPMemoryMgrRef 	memMgr;
} PGPldapContext;

typedef struct PGPldapMessage
{
	PGPldapMessageID		messageID;
	PGPldapType 			type;

	/*
	 * This is just a pointer to the PGPberElement. Freeing the 
	 * PGPldapMessage does not mean freeing the PGPberElement.
	 */
	PGPberElementRef		ber;

	struct PGPldapMessage *	next;
	struct PGPldapMessage *	prev;

} PGPldapMessage;

typedef struct PGPldapMessageSort
{
	PGPldapMessageRef	message;
	PGPldapContextRef	pgpLDAP;
	char *				attr;
	PGPInt32			(*compare)( const void * a, const void * b );
} PGPldapMessageSort;

PGPError	pgpNewLDAPURLDesc(
							PGPldapContextRef	pgpLDAP,
							PGPldapURLDesc **	lud );
PGPError	pgpLDAPSend(
							PGPldapContextRef	pgpLDAP,
							PGPberElementRef	ber );
PGPError	pgpCopyLDAPMessage(
							PGPldapMessageRef	src,
							PGPldapMessageRef	dst );
PGPError	pgpLDAPGetMessageErrno(
							PGPldapContextRef	pgpLDAP,
							PGPldapMessageRef	message );
PGPError	pgpLDAPGetSubstring(
							char *				value,
							char *				substring,
							PGPldapSubstring *	substringType,
							PGPSize *			inc );
PGPError	pgpLDAPGetSubfilter(
							char *				filter,
							char *				subfilter );
PGPError	pgpLDAPAddFilter(
							PGPldapContextRef	pgpLDAP,
							PGPberElementRef	ber,
							char *				inFilter );
PGPError	pgpLDAPCountValues(
							PGPldapContextRef	pgpLDAP,
							PGPberElementRef	ber,
							PGPSize	*			num );
PGPInt32	pgpLDAPSortCompare(
							const void *		s1,
							const void *		s2 );

#endif /* ] Included_pgpLDAPPriv_h */


/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
